#! c:\perl\bin\perl.exe
#
# Search for files, preserve size and MAC time info
#
use strict;
use Getopt::Long;
my %config = ();
Getopt::Long::Configure("prefix_pattern=(-|\/)");
GetOptions(\%config, qw(office|o dir|d=s graphic|g mail|m help|?|h));
\usage();
exit 0 if (!%config || $config{help});
my $dir = $config{dir} || Win32::GetCwd;
print "Start search,".time.",".localtime(time)."\n";
print "File,Size,Last Access,Last Modification,Creation\n";
\&Search($dir);
print "Search complete,".time.",".localtime(time)."\n";
# Thanks to Dave Roth for recursive search algorithm
# instead of using File::Find
sub Search {
my $dir = $_[0];
if (opendir(FH,$dir)) {
my (@dirs,@files);
while (my $file = readdir(FH)) {
next if ($file eq "." || $file eq "..");
my $path = "$dir\\$file";
push (@dirs,$path) if (-d $path);
push (@files,$path) if (-f $path);
}
closedir(FH);
foreach my $file (@files) {
\macdaddy($file);
}
foreach my $path (@dirs) {
\&Search($path);
}
}
}
# macdaddy()
# print size and MAC time for each file
sub macdaddy {
my $file = $_[0];
my ($size,$atime,$mtime,$ctime) = (stat($file))[7..10];
my $a_time = localtime($atime);
my $m_time = localtime($mtime);
my $c_time = localtime($ctime);
print "$file,$size,$a_time,$m_time,$c_time\n";
}
# display usage information
sub usage {
print STDERR "\nSearch Files v. 1.0\n";
print STDERR "Search for specific types of files, and preserve their paths, sizes, \n";
print STDERR "and MAC times.\n";
print STDERR "\nUsage: sfile [-d dir]\n";
print STDERR " -d Directory to search. May be a mapped dir, or UNC path\n";
print STDERR " (default: current working directory)\n";
print STDERR "By default, search starts at current dir.\n";
print STDERR "NOTE: Beginning and end of search are timestamped. Output is in CSV format\n";
print STDERR " for easy opening in Excel.\n\n";
}
