#! c:\perl\bin\perl.exe
# Perl script to perform file signature analysis
use strict;
my $file = shift || die "Must supply a filename.\n";
my %sigs;
my $sig_file_read = 0;
my $sig_file = "sigs";
if (-e $sig_file) {
if (readsigfile($sig_file)) {
print "Signature file successfully read.\n";
$sig_file_read = 1;
foreach (keys %sigs) {
my @list = @{$sigs{$_}};
}
}
else {
print "Signature file not read.\n";
}
}
my $ext = getext($file);
print "File:\t$file\n";
print "Ext :\t$ext\n";
my $hex = getsig($file);
print "Hex :\t$hex\n";
print "\n";
if ($sig_file_read) {
my $match = 0;
foreach my $key (keys %sigs) {
if ($hex =~ m/^$key/) {
$match = 1;
if (grep(/$ext/,@{$sigs{$key}})) {
print "File extension corresponds to file signature.\n";
}
else {
print "File signature does not match extension.\n";
}
}
}
print "File signature not matched.\n" if (!$match);
}
sub getext {
my $file = $_[0];
my $ext;
my @filelist = split(/\./,$file);
(@filelist - 1) ? ($ext = $filelist[@filelist - 1]) :
($ext = "none");
return $ext;
}
sub getsig {
my $file = $_[0];
open(FH, $file) || die "Could not open $file: $!\n";
binmode(FH);
my $bin;
sysread(FH,$bin,20);
close(FH);
my $hex = uc(unpack("H*",$bin));
return $hex;
}
sub readsigfile {
my $file = $_[0];
if (-e $file) {
open(FH,$file) || die "Could not open $file: $!\n";
while() {
next if ($_ =~ m/^#/ || $_ =~ m/^\s+$/);
chomp;
my ($sig,$tag) = split(/:/,$_,2);
my @list = split(/,/,$tag);
$sigs{$sig} = [@list];
}
close(FH);
return 1;
}
else {
return undef;
}
}
#
# Sample signature file contents
# file signatures
#424D:bmp
#3A42617365:cnt
# Microsoft compressed file
#4D534346:ex_,dl_,dr_,sy_
#D0CF11E0A1B11AE1:doc,xls,xlt
#0100000058000000:emf
#03000000C466C456:evt
#4D5A:exe,sys,dll,drv,flt,fon,ocx,scr,lib
#3F5F0300:gid
#474946383961:gif
#474946383761:gif
#1F8B08:gz
#28546869732066696C65:hqx
#00000100.00:ico
#FFD8FFFE00:jpg,jpe,jpeg
#FFD8FFE000:jpg,jpe,jpeg
#4C000000011402:lnk
#25504446:pdf
#5245474544495434:reg
#7B5C727466:rtf
#504B0304:zip
